/*jshint unused: vars */

define(["lib/Zoot"],
function (Z) {
	"use strict";
	var assert = Z.utils.assert;

	
	return {
		about: "ParamTest -- behavior for testing parameters.",
		description: "For internal testing only.",
		uiName: "ParamTest",
		hideInBehaviorList: true,
		defaultArmedForRecordOn: true,

		defineTags: function () {
			return {
				aTags: [
					{
						id: "Adobe.ParamTest.Foo",	
						artMatches: [],
						uiName: "Foo",
						tagType: "layertag"
					},

					{
						id: "Adobe.ParamTest.Bouche",	
						artMatches: [],
						uiName: "Bouche",
						tagType: "layertag"
					},

					{
						id: "Adobe.ParamTest.Child",	
						artMatches: [],
						uiName: "Child",
						tagType: "layertag"
					},

					{
						id: "Adobe.ParamTest.Bar",	
						artMatches: [],
						uiName: "Bar",
						tagType: "handletag"	
					},

					{
						id: "Adobe.ParamTest.Boo",	
						artMatches: [],
						uiName: "Boo",
						tagType: "handletag"
					},

					{
						id: "Adobe.ParamTest.Zit",	
						artMatches: [],
						uiName: "Zit",
						tagType: "handletag"
					},
					{
						id: "Adobe.Face.Front",
						artMatches: ["frontal"],
						uiName: "$$$/animal/Behavior/Face/TagName/Frontal=Frontal",
						tagType: "layertag",
						uiGroups: [{ id:"Adobe.TagGroup.HeadTurn", subSort:0}]				
					},
					{
						id: "Adobe.Face.RightProfile",
						artMatches: ["right profile"],
						uiName: "$$$/animal/Behavior/Face/TagName/RightProfile=Right Profile",
						tagType: "layertag",
						uiGroups: [{ id:"Adobe.TagGroup.HeadTurn", subSort:0}]				
					}
				]
			};
		},
		
		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{id:"param1_slider",	type:"slider", uiName:"Funky Slider", precision:1, uiUnits:"%", dephault:101},
				{id:"param2_angle",		type:"angle", uiName:"Funky Angle", precision:0, dephault:102},
				{id:"param3_layer",		type:"layer", uiName:"1-Find One 'Foo'", dephault:{match:"//Adobe.ParamTest.Foo"}, maxCount: 1},
				{id:"param7_rootlayer",	type:"layer", uiName:"2-Find Root", dephault:{match:"."}},
				{id:"param5_layers",	type:"layer", uiName:"3-Find All 'Bouche'", dephault:{match:"//Adobe.ParamTest.Bouche"}},
				{id:"param9_parent",	type:"layer", uiName:"4-Find All 'Child' under 1", dephault:{match:"//Adobe.ParamTest.Child", startMatchingAtParam:"param3_layer"}},
				{id:"param10_parent",	type:"layer", uiName:"5-Find All 'Child' under 3", dephault:{match:"//Adobe.ParamTest.Child", startMatchingAtParam:"param5_layers"}},
				{id:"param4_handle",	type:"handle", uiName:"Funky Single 'Bar' Handle", dephault:{match:"//Adobe.ParamTest.Bar"}, maxCount: 1},
				{id:"param6_handles",	type:"handle", uiName:"Funky 'Boo' Handles", dephault:{match:"//Adobe.ParamTest.Boo"}},
				{id:"param8_roothandle", type:"handle", uiName:"Funky Root Handle", dephault:{match:"."}},
				{id:"param11_view",		type:"layer", uiName:"View Parent Group", dephault:{match:"//Adobe.Face.Front|Adobe.Face.RightProfile"}},
				{id:"param12_sMAPhandle", type:"handle", uiName:"Handles per view", dephault:{match:"//Adobe.ParamTest.Zit", startMatchingAtParam:"param11_view"}},
				{id:"param13_sMAPhandle", type:"handle", uiName:"Handle per view", dephault:{match:"//Adobe.ParamTest.Zit", startMatchingAtParam:"param11_view"}, maxCount: 1},
				{id:"param14_rootlaySMAP", type:"layer", uiName:"root layer of parents", dephault:{match:".", startMatchingAtParam:"param11_view"}},
				{id:"param15_rootSMAP", type:"handle", uiName:"root handle of parents", dephault:{match:".", startMatchingAtParam:"param11_view"}}
			];
		},

		onCreateBackStageBehavior: function (self) {
		},

		onCreateStageBehavior: function (self, args) {
			var p1, p2, p3, p4, p5, p6, p7, p8, layer, s7, p11, p14, p15;
			
			p1 = args.getStaticParam("param1_slider");
			assert(p1 === 101, "value of param1 is not 101");
			
			p2 = args.getStaticParam("param2_angle");
			assert(p2 === 102, "value of param2 is not 102");
			
			p3 = args.getStaticParam("param3_layer");
			assert(p3.length === 1 && p3[0].getName() === "Foo", "value of param3");
			layer = p3[0];
		//	layer.setOpacity(0.5);  -- test this once ReplacerUtils supports partial alpha
			layer.setVisible(false);

			assert(layer.getVisible() === false);
			
			p7 = args.getStaticParam("param7_rootlayer");
			assert(p7.length === 1, "should be one match for p7 rootlayer");
			s7 = p7[0].getSource();
			assert(s7.getName() === "ThePuppet", "name of p7 should be ThePuppet");
			
			p5 = args.getStaticParam("param5_layers");
			assert(p5.length === 2, "should be two Bouche layers matched");
			assert(p5[0].getName() === "Bouche (in Foo)", "first Bouche name mismatch");
			assert(p5[1].getName() === "Bouche (in Bar)", "second Bouche name mismatch");
			
			p4 = args.getStaticParam("param4_handle");
			assert(p4.length === 1, "Single should match one handle");
			assert(p4[0].getName() === "Bar 1");
			
			p6 = args.getStaticParam("param6_handles");
			assert(p6.length === 2, "Mult should match two handles");
			assert(p6[0].getName() === "Boo 2");	// (Boo 1 is a location tag only, no handle, so it doesn't match)
			assert(p6[1].getName() === "Boo 3");
			
			p8 = args.getStaticParam("param8_roothandle");
			assert(p8.length === 1, "Root should match one handle");
			assert(p8[0].getName() === "origin");
			
			p11 = args.getStaticParam("param11_view");
			p14 = args.getStaticParam("param14_rootlaySMAP");
			p15 = args.getStaticParam("param15_rootSMAP");
			assert(p11.length === 2);
			assert(p14.length === 2 && p14[0].length === 1 && p14[1].length === 1);
			assert(p15.length === 2 && p15[0].length === 1 && p15[1].length === 1);
			assert(p11[1] === p14[1][0]);
		},

		onAnimate: function (self, args) {
			var p1, p2, p3, layer; // p4, p5, p6, p7, p8, p9, mat3, ;

			p1 = args.getParam("param1_slider");
			p2 = args.getParam("param2_angle");
			p3 = args.getParam("param3_layer");
			
			assert(p1 === 101, "value of param1 is not 101 in onAnimate");
			assert(p2 === 102, "value of param2 is not 102 in onAnimate");

			layer = p3[0];
			layer.setOpacity(1);
			layer.setVisible(true);
			
			assert(layer.getVisible() === true);
			
//			p4 = args.getParam("param4_handle");
//			p5 = args.getParam("param5_layers");
//			p6 = args.getParam("param6_handles");
//			p7 = args.getParam("param7_rootlayer");
//			p8 = args.getParam("param8_roothandle");
//			p9 = args.getParam("param9_parent");

//			mat3 = Z.Mat3.affine([10,10], [1,1], [0,0], 0);
//			p6.forEach(function (h, i) {
//				h.setMatrix(mat3);
//			});
		}

	}; // end of object being returned
});
